package com.androidbook.simplendk;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

public class NativeBasicsActivity extends Activity {
    private static final String DEBUG_TAG = "NativeBasicsActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.native_basics);
    }

    public void onBasicCall(View view) {
        basicNativeCall();
    }

    public void onBasicWithParams(View view) {
        String sumString = formattedAddition(5, 2, "To jest suma: ->%i<-");
        Log.d(DEBUG_TAG, sumString);
        sumString = formattedAddition(7965, 413372, "Inny wynik: %i");
        Log.d(DEBUG_TAG, sumString);
    }

    public void onExceptional(View view) {
        try {
            throwsException(42);
            throwsException(25);
            throwsException(55); // tu nie dotrzemy
        } catch (IllegalArgumentException e) {
            Log.e(DEBUG_TAG, "Wywołanie nieudane: ", e);
        }
    }

    public void onCatches(View view) {
        checksException(42);
        checksException(21);
    }

    @SuppressWarnings("unused")
    // wywoływana z kodu rodzimego
    private void javaThrowsException(int num) throws IllegalArgumentException {
        if (num == 42) {
            throw new IllegalArgumentException("Wszystko, tylko nie ta liczba!");
        } else {
            Log.v(DEBUG_TAG, "Dobry wybór!");
        }
    }

    private native void basicNativeCall();

    private native String formattedAddition(int num1, int num2,
        String formatString);

    private native void throwsException(int num) throws IllegalArgumentException;

    private native void checksException(int num);

    static {
        System.loadLibrary("simplendk");
    }
}
